<?php
/*
Plugin Name: مکمل افزونه پیامک ووکامرس MYDNSPANEL
Version: 2.4.1
Description: این افزونه امکان استفاده از سامانه های پیامک mydnspanel در افزونه پیامک حرفه ای ووکامرس را فراهم می کند.
*/

if (!defined("ABSPATH")) {
    exit();
}
if (!function_exists("is_plugin_active")) {
    include_once ABSPATH . "/wp-admin/includes/plugin.php";
}
function check_woocommerce_sms_plugin()
{
    if (!is_plugin_active("persian-woocommerce-sms/WoocommerceIR_SMS.php")) {
        add_action("admin_notices", "show_sms_plugin_error");
        deactivate_plugins(plugin_basename(__FILE__));
    }
}
function show_sms_plugin_error()
{
    ?>
    <div class="notice notice-error">
        <p><?php _e(
            "افزونه مکمل MYDNSPANEL تنها وقتی کار می کند که شما افزونه پیامک حرفه ای ووکامرس را نصب و فعال کرده باشید. لطفا پس از نصب افزونه پیامک ووکامرس این افزونه مکمل را فعال نمایید.",
            "my-text-domain"
        ); ?></p>
    </div>
    <?php
}
function get_file_version($file_path)
{
    $file_content = file_get_contents($file_path);
    if (preg_match("/Version:\s*(\d+\.\d+)/", $file_content, $matches)) {
        return $matches[1];
    }
    return null;
}
function pwoo_sms_mydnspanel_activate()
{
    $source_file = plugin_dir_path(__FILE__) . "mydnspanelClass.php";
    $destination_dir = WP_PLUGIN_DIR . "/persian-woocommerce-sms/src/Gateways";
    $destination_file = $destination_dir . "/MydnsPanelSms.php";
    $required_version = "2.4";
	if (file_exists($source_file)) {
		if (!is_dir($destination_dir)) {
			mkdir($destination_dir, 0755, true);
		}
		$mydnsPanelCopy = copy($source_file, $destination_file);
		if($mydnsPanelCopy!=1){
			wp_die("در تنظیم افزونه اصلی خطایی رخ داده است ، با پشتیبانی در ارتباط باشید");
		}
	} else {
		wp_die("فایل MydnsPanelSms.php در پوشه افزونه شما پیدا نشد.");
	}
}
add_action("admin_init", "check_woocommerce_sms_plugin");
register_activation_hook(__FILE__, "pwoo_sms_mydnspanel_activate");
add_action(
    "pwoosms_main_settings",
    "pwoosms_main_settings_mydnspanel"
);

add_action(
    "pwoosms_settings_form_bottom_sms_main_settings",
    "mydnspanelsms_admin_settings"
);
add_action(
    "pwoosms_settings_form_bottom_sms_super_admin_settings",
    "mydnspanelsms_patternscript"
);
add_action(
    "pwoosms_settings_form_bottom_sms_buyer_settings",
    "mydnspanelsms_patternscript"
);
add_action(
    "pwoosms_settings_form_bottom_sms_product_admin_settings",
    "mydnspanelsms_patternscript"
);
add_action(
    "pwoosms_settings_form_bottom_sms_notif_settings",
    "mydnspanelsms_patternscript",
    10,
    1
);
add_action("wp_ajax_pwoo_sms_mydnspanel_CheckPattern", "mydnspanelsms_checkPattern");
add_action("wp_ajax_pwoo_sms_mydnspanel_test", "mydnspanelsms_sendtest");
if(!function_exists("mydnspanel_pwooSMS_getServerIP")){
	function mydnspanel_pwooSMS_getServerIP(){
		$apiHandler = curl_init("mydnspanel.com/webservice/ip");
		curl_setopt($apiHandler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($apiHandler, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($apiHandler, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($apiHandler, CURLOPT_TIMEOUT, 30);
		curl_setopt($apiHandler, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($apiHandler, CURLOPT_SSL_VERIFYPEER, 0);
		$response = [];
		$response["data"] = json_decode(curl_exec($apiHandler), true);
		$response["code"] = curl_getinfo($apiHandler, CURLINFO_HTTP_CODE);
		if ($response["code"] == 200) {
			if ($response["data"]["status"] == "true") {
				return $response["data"]["ip"];
			}
		}
		return "connection_error";
	}
}
function pwoosms_main_settings_mydnspanel()
        {
		$gateways_list = [ 'PW\PWSMS\Gateways\MydnsPanelSms' => 'MYDNSPANEL' ];
		$newordersettings = [];
            $settings = [
				[
					'name'    => 'sms_gateway',
					'label'   => 'وبسرویس پیامک',
					'type'    => 'select',
					'default' => 'MydnsPanelSms',
					'desc'    => 'برای اطلاع از هزینه ها و شرایط خدمات دهی هر سرویس به وب سایت های آن ها مراجعه کنید. ووکامرس فارسی تعهدی در قبال ارائه خدمات این شرکت ها ندارد و صرفا ارائه دهنده افزونه پیامک هستیم.',
					'options' => $gateways_list,
					'ltr'     => true,
				],
				[
					'name'  => 'sms_gateway_username',
					'label' => 'نام کاربری وبسرویس',
					'type'  => 'text',
					'ltr'   => true,
				],
				[
					'name'  => 'sms_gateway_password',
					'label' => 'کلمه عبور وبسرویس',
					'type'  => 'text',
					'ltr'   => true,
				],
				[
					'name'  => 'sms_gateway_sender',
					'label' => 'شماره ارسال کننده پیامک',
					'type'  => 'text',
					'ltr'   => true,
					'desc'  => $gateway ? sprintf( 'یک پیامک تستی جهت بررسی صحت تنظیمات درگاه پیامک %sارسال نمایید.%s',
						'<a href="' . admin_url( 'admin.php?page=persian-woocommerce-sms-pro&tab=send' ) . '">',
						'</a>' ) : '',
				],
				[
					'name'  => 'enable_admin_bar',
					'label' => 'لینک ارسال پیامک در ادمین بار',
					'desc'  => 'با فعالسازی این گزینه، لینک ارسال پیامک جهت دسترسی سریع تر به ادمین بار اضافه خواهد شد.',
					'type'  => 'checkbox',
				],
			];
            foreach ($settings as $setting) {
                if ($setting["name"] == "sms_gateway") {
                    $setting["desc"] =
                        "جهت استفاده از این پلاگین باید از یکی از سامانه هایی که از سورس MyDNSPanel استفاده می کنند سامانه پیامکی داشته باشید";
                    $newordersettings[] = $setting;
                } elseif ($setting["name"] == "sms_gateway_username") {
                    $setting["label"] = "تلفن همراه وب سرویس";
                    $setting["desc"] =
                        "تلفن همراه خود را در سامانه پیامک وارد نمایید";
                    $newordersettings[] = $setting;
                } elseif ($setting["name"] == "sms_gateway_password") {
                    $setting["label"] = "کلید اتصال وب سرویس";
                    $setting["desc"] =
                        "جهت دریافت کلید اتصال پس از ورود به پنل پیامک خود از منوی وب سرویس و پلاگین ها > کلید های اتصال اقدام نمایید. ای پی جهت تنظیم کلید اتصال : " . mydnspanel_pwooSMS_getServerIP();
                    $newordersettings[] = $setting;
                } elseif ($setting["name"] == "sms_gateway_sender") {
                    $setting["default"] = "auto";
                    $setting["desc"] =
                        "شماره فرستنده اختصاصی خود را جهت ارسال پیامک وارد نمایید ، در صورتی که شماره فرستنده اختصاصی ندارید می توانید مقدار را برابر auto قراردهید";
                    $newordersettings[] = $setting;
                    $newordersettings[] = [
                        "name" => "sms_gateway_phoneBook",
                        "label" => "شناسه دفترچه تلفن",
                        "type" => "text",
                        "ltr" => 1,
                        "desc" =>
                            "در صورتی که تمایل داشته شماره تلفن کاربرانی که به آن ها ارسال پیامک انجام می شود در دفترچه تلفن پنل پیامک شما ذخیره گردد می توانید شناسه دفترچه تلفن مورد نظر در پنل پیامک را وارد نمایید",
                        "default" => "0",
                    ];
                } else {
                    $newordersettings[] = $setting;
                }
            }
            return $newordersettings;
        }
function mydnspanelsms_admin_settings()
{
    if (PWSMS()->get_option("sms_gateway") == "PW\PWSMS\Gateways\MydnsPanelSms") {
        $credit = mydnspanelsms_getCredit();
		if (is_numeric($credit)) {
			$credit_help = "";
			if ($credit < 10000 && $credit > 1000) {
				$alertClass = "notice-warning";
				$credit_help =
					" (<i> جهت شارژ اعتبار به پنل پیامک مراجعه و از منوی مالی > افزایش اعتبار را کلیک نمایید </i>)";
			} elseif ($credit < 1000) {
				$alertClass = "notice-error";
				$credit_help =
					" (<i> جهت شارژ اعتبار به پنل پیامک مراجعه و از منوی مالی > افزایش اعتبار را کلیک نمایید </i>)";
			} else {
				$alertClass = "notice-info";
			}
			$credit = number_format($credit) . " تومان " . $credit_help;
			$panelExpire = mydnspanelsms_userData("remainingDays");
			@$panelExpireDay =$panelExpire["day"] != null? $panelExpire["day"]: "none";
			$expire_help = "";
		} else {
			$credit =
				"امکان بررسی اعتبار شما از پنل پیامک نیست. خطای درگاه: " .
				$credit;
			$alertClass = "notice-error";
			$panelExpire = mydnspanelsms_userData("remainingDays");
			if(isset($panelExpire["day"])){
				@$panelExpireDay =$panelExpire["day"]!=null?$panelExpire["day"]:"none";
			} else {
				$panelExpireDay = "none";
			}
		}
		if (is_numeric($panelExpireDay) && $panelExpireDay < 15) {
			$alertClass = "notice-warning";
			$expire_help =
				" ( <i>برای تمدید پنل با پشتیبان سامانه پیامک تماس بگیرید</i> )";
		}
		if(isset($panelExpire["status"])){
			@$panelExpireStatus =$panelExpire["status"] != null? $panelExpire["status"]: "none";
		} else {
			$panelExpireStatus = "امکان دریافت انقضا پنل وجود ندارد";
		}
		$mydnspanelBox =
			'<div class="mydnspanelnotice ' .
			$alertClass .
			'"><strong>اطلاعات پنل پیامک</strong><br><br>';
		$mydnspanelBox .=
			"<strong>اعتبار فعلی پنل پیامک : </strong><span>" .
			$credit .
			" </span><br>";
		$mydnspanelBox .=
			"<strong>تعداد روزهای باقی مانده تا انقضا پنل پیامک : </strong><span>" .
			$panelExpireStatus .
			$expire_help .
			" </span><br>";
		$mydnspanelBox .=
			"</div><style>.mydnspanelnotice {background: #fff;border: 1px solid #ccd0d4;border-right-width: 4px;box-shadow: 0 1px 1px rgba(0,0,0,.04);margin: 5px 15px 2px;padding: 10px;}.mydnspanelnotice.notice-info {border-right-color: #00a0d2;}.mydnspanelnotice.notice-warning {border-right-color: #ffb900;}.mydnspanelnotice.notice-error {border-right-color: #dc3232;}</style>";
        print $mydnspanelBox;
    }
}
function mydnspanelsms_getCredit()
{
	$apiParam = ["action" => "credit"];
	$result = mydnspanelsms_cUrl($apiParam);
	$response = json_decode($result, true);
	$responseCode = $response["result"];
	$responseCredit = $response["credit"];
	if ($responseCode == 1) {
		return ceil(str_replace(",", "", $responseCredit));
	} else {
		return mydnspanelsms_getErrors($responseCode);
	}
}
function mydnspanelsms_userData($type)
{
	$apiParam = ["action" => "userData"];
	$result = mydnspanelsms_cUrl($apiParam);
	$response = json_decode($result, true);
	$responseCode = $response["result"];
	$responseData = $response["data"];
	if ($responseCode == 1) {
		if ($type == "remainingDays") {
			if (
				!empty($responseData["expireRemaining"]) &&
				!is_null($responseData["expireRemaining"])
			) {
				return [
					"day" => $responseData["expireRemaining"],
					"status" => $responseData["expireStatus"],
				];
			} elseif ($responseData["expire"] == "none") {
				return [
					"day" => "none",
					"status" => "بدون تاریخ انقضا",
				];
			} else {
				return [
					"day" => "none",
					"status" => "-",
				];
			}
		} else {
			return "-";
		}
	} else {
		return mydnspanelsms_getErrors($responseCode);
	}
}
function mydnspanelsms_debug($data = null)
{
    $file = @file_get_contents("mydnspanelsms_debug.txt");
    if (is_array($data) || is_object($data)) {
        $data = json_encode($data);
    }
    @file_put_contents("mydnspanelsms_debug.txt", $file . "\n" . $data);
    return;
}
function mydnspanelsms_checkPattern()
{
	if (isset($_POST["patternCode"])) {
		$apiParam = [
			"action" => "patternData",
			"patternId" => esc_html(trim($_POST["patternCode"])),
		];
		$result = mydnspanelsms_cUrl($apiParam);
		$response = json_decode($result, true);
		$responseCode = $response["result"];
		$responseParams = $response["params"];
		if ($responseCode == 1) {
			echo json_encode($response);
		} else {
			echo json_encode([
				"result" => $responseCode,
				"error" => mydnspanelsms_getErrors($responseCode),
			]);
		}
	} else {
		echo "-1";
	}
	wp_die();
}
function mydnspanelsms_sendtest()
{
    $datas = [
        "message" => $_POST["body"],
        "mobile" => explode(",", $_POST["phone"]),
    ];
    print PWSMS()->send_sms($datas);
    die();
}
function mydnspanelsms_cUrl($params = [], $method = "POST")
{
    $params["xPlugin"] = "persian-woo.2-4";
	$apiHandler = curl_init("mydnspanel.com/webservice/server");
	curl_setopt($apiHandler, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($apiHandler, CURLOPT_HTTPHEADER, [
		"Authorization: " . trim(PWSMS()->get_option("sms_gateway_password")),
	]);
	curl_setopt($apiHandler, CURLOPT_POSTFIELDS, $params);
	curl_setopt($apiHandler, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($apiHandler, CURLOPT_CONNECTTIMEOUT, 20);
	curl_setopt($apiHandler, CURLOPT_TIMEOUT, 30);
	curl_setopt($apiHandler, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($apiHandler, CURLOPT_SSL_VERIFYPEER, 0);
	$response = curl_exec($apiHandler);
	if (curl_errno($apiHandler)) {
		return json_encode([
			"result" => "-1",
			"error" => curl_error($apiHandler),
		]);
	}
	return $response;
}
function mydnspanelsms_patternscript($form = null)
{
    add_thickbox(); ?>
<div id="pattern-teach" style="display:none;">
<p><strong>پترن یا الگو چیست ؟</strong></p><p>	در صورتی که در کادر متن یک متن را وارد نمایید به صورت عادی ارسال می گردد ( متن های عادی پس از تایید بخش مانیتورینگ سامانه ارسال می گردد در نهایت با کمی تاخیر ارسال می شود ) اما اگر الگو یا پترن را تنظیم نمایید پیام ها به صورت سریع و بدون تایید ارسال می گردد .</p><p>برای ارسال بر اساس پترن، روی ابزار تنظیم پترن کنار هر کادر متن پیامک کلیک کنید و بر اساس دستورالعملی که در ادامه می آید، پترن خود را ثبت نمایید.</p><p><strong>ثبت پترن یا الگو اختصاصی :</strong></p><p>	در صورتی که بخواهید متن پیامک خود را در سامانه پیامک تبدیل به پترن نمایید از دستورالعمل زیر استفاده نمایید.</p><p>	وارد پنل پیامک خود شوید و در منوی وب سرویس و پلاگین ها گزینه &laquo;الگوها یا پترن ها&raquo; را کلیک کنید.</p><p> سپس گزینه &laquo;افزودن الگو جدید&raquo; را کلیک کنید.</p><p>متن پترن خود را وارد نمایید مانند متن زیر، سپس دکمه ثبت را کلیک نمایید:</p><p>	<strong>مشتری گرامی {name}<br />	سفارش شما به شماره {order_id} ثبت شد.<br/> مبلغ قابل پرداخت: {price}<br/><?php print get_option("blogname"); ?></strong></p><p>	(متن پترن را طبق صلاح خود وارد کنید اما حتما نام فروشگاه خود را ثبت کنید)</p><p>	بعد از ثبت موفق پترن منتظر بمانید تا پترن شما تایید شود. وضعیت تایید یا رد پترن خود را در صفحه &laquo;لیست الگوهای ثبت شده&raquo; در همان منو پنل پیامک خود می توانید مشاهده کنید.</p><p>	پس از اینکه پترن تایید و فعال شد، تنظیمات متن پیامک این افزونه را به شکل زیر انجام دهید:</p><p>روی لینک ابزار تنظیم پترن کلیک کنید و طبق راهنمای آن کد پترن و متغیرهایش را در کادرهای مربوطه وارد نمایید و دکمه "درج پترن در کادر مربوطه" را کلیک کنید</p><p>	سپس دکمه ذخیره تغییرات را کلیک کنید.</p>
</div>
<div id="pattern-tool-wrapper" style="display:none;">
<div id="pattern-tool">
</div>
</div>
<script>
( function ( $ ) {
function activate_pwoosms_mydnspanel_pattern_tools(){
var textarea_index = 1;
$('textarea.regular-text').not('#sms_notif_settings\\[notif_options\\]').each(function(){
$(this).parents('tr').addClass('pwoo_mydnspanel_tools trindex-'+textarea_index).attr('id','trindex-'+textarea_index);
if($(this).attr('id') == 'sms_super_admin_settings[admin_low_stock]' || $(this).attr('id') == 'sms_super_admin_settings[admin_out_stock]') $(this).parents('tr').addClass('outofstock');
textarea_index++;
});
$('tr.pwoo_mydnspanel_tools').find('th label').after('<div class="mydnspanel-tools"><a class="mydnspanel-patternlearn thickbox button button-secondary" href="#TB_inline?width=800&inlineId=pattern-teach">آموزش ثبت پترن</a><a class="mydnspanel-patterntool thickbox button button-secondary" href="#TB_inline?width=800&inlineId=pattern-tool-wrapper">ابزار تنظیم پترن</a><a class="mydnspanel-smstest button button-secondary">تست پیامک</a></div>');
$('.mydnspanel-patterntool').on('click',function(){
<?php if (
    isset($form["id"]) &&
    in_array($form["id"], [
        "sms_super_admin_settings",
        "sms_buyer_settings",
        "sms_product_admin_settings",
    ])
) { ?>
    var targetvars = $('.pwoosms_settings_shortcodes').html().replace(/code/g,'span');
    if($(this).parents('tr').hasClass('outofstock')) targetvars = '<div class="description" style="margin-top:4px;color:#616161;font-style:italic;font-size:13px;line-height:25px;"> شورت کد های قابل استفاده در متن پیامک های مرتبط با موجوی انبار :<br><span>{product_id}</span> : آیدی محصول، <span>{sku}</span> : شناسه محصول، <span>{product_title}</span> : عنوان محصول، <span>{stock}</span> : موجودی انبار</div>';
<?php } elseif (isset($form["id"]) && $form["id"] == "sms_notif_settings") { ?>
    var targetvars = '<div class="description" style="margin-top:4px;color:#616161;font-style:italic;font-size:13px;line-height:25px;"> <span>{product_id}</span> : آیدی محصول، <span>{sku}</span> : شناسه محصول، <span>{product_title}</span> : عنوان محصول، <span>{regular_price}</span> قیمت اصلی، <span>{onsale_price}</span> : قیمت فروش فوق العاده<br><span>{onsale_from}</span> : تاریخ شروع فروش فوق العاده، <span>{onsale_to}</span> : تاریخ اتمام فروش فوق العاده، <span>{stock}</span> : موجودی انبار</div>';
<?php } else { ?>
    var targetvars = 'متغیری در صفحه یافت نشد. در صورتی که متغیرها را می دانید از آنها استفاده کنید.';
<?php } ?>
var targetarea = $(this).parents('tr').find('textarea');
var patternToolText = 'پس از ثبت پترن در سامانه پیامک و تأیید آن، کد پترن یا شناسه وب سرویس را در کادر زیر وارد نمایید :<div id="onlinepattern"><label>کد پترن:</label> <input class="patterncodeinput" placeholder="کد پترن شما" type="text"><div class="pattern-message"></div><div><button class="onlinepcodechecker" type="button">بررسی پترن</button></div><div class="pcodecheckresult"></div><div class="variableshelp hidden">'+targetvars+'</div><div><button class="patterninsert hidden" type="button">ثبت پترن در کادر پیامک</button></div></div><br><div><b>راهنمایی:</b><p class="mydnspanelpatternstephelp"> متن پیامک خود را در سامانه پیامک > منوی وب سرویس و پلاگین ها > الگو ها و پترن ها، تبدیل به پترن کنید.پس از اینکه پترن شما تأیید شد، کد پترن یا شناسه وب سرویس را از صفحه لیست الگوهای ثبت شده کپی و در کادر فوق درج نمایید.</p></div>';
$('div#pattern-tool').html(patternToolText);

$('.onlinepcodechecker').on('click',function(){
    pcode = $('#onlinepattern .patterncodeinput').val();
    jQuery.ajax({
        type: 'post',
        async: true,
        url: '<?php print admin_url("admin-ajax.php"); ?>',
        data: {
            action: 'pwoo_sms_mydnspanel_CheckPattern',
            patternCode: pcode,
        },
        beforeSend: function(){
            $('#onlinepattern .pattern-message').html('<span class="process-icon-loading">در حال بررسی...</span>');
        },
        success: function (json) {

            var obj = JSON.parse(json);
            console.log(obj);
            var message = '';

                  if(obj.result == 1){
                    $('#onlinepattern .pattern-message').html(obj.text.replace("\n","<br>"));
					var pvars = obj.params;
                    var output = '<p>لطفاً پارامترهای پترن را با متغیرهای سایت تکمیل نمایید.</p>';
                    pvars.forEach(function(value, index, array){
                        output += '<div><label>'+value+'</label><input type="text"/></div>';
                    });
                    $('.pcodecheckresult').html(output);
                    $('.variableshelp,.patterninsert').removeClass('hidden');
                    $('.onlinepcodechecker').addClass('hidden');
                    $('.mydnspanelpatternstephelp').html('حالا پارامترهای پترن خود را در کادرهای ظاهر شده تکمیل نمایید. از شورتکدهای زیر می توانید استفاده نمایید.');
                    var patternoutput = 'patternID:'+pcode;
                    $('.patterninsert').click(function(){
                        $('.pcodecheckresult div').each(function(){
                            if(patternoutput !== '') patternoutput += "\n";
                            patternoutput += $(this).find('label').text()+':'+$(this).find('input').val();
                        })
                        targetarea.val(patternoutput).css('direction','ltr');
                        $('.tb-close-icon').click();
                    });
                  }else if(obj.result == 901){
							  $('#onlinepattern .pattern-message').html('کد پترن یا شناسه وب سرویس الگو صحیح نیست و یا متعلق به شما نمی باشد');
						  }else if(obj.result == 902){
							  $('#onlinepattern .pattern-message').html('پترن مورد نظر در انتظار تایید می باشد ، لطفا صبور باشید تا پترن شما تایید گردد');
						  }else if(obj.result == 903){
							  $('#onlinepattern .pattern-message').html('پترن مورد نظر تایید نشده است ، لطفا وارد پنل پیامک شوید و توضیحات کارشناس را بررسی کنید');
						  }else if(obj.result == '-1'){
							  $('#onlinepattern .pattern-message').html('کلید اتصال وب سرویس صحیح نمی باشد ، از تنظیمات درگاه بررسی نمایید');
						  }else if(obj.result == '-2'){
							  $('#onlinepattern .pattern-message').html('دسترسی وب سرویس غیرفعال است ، لطفا با پشتیبانی تماس بگیرید');
						  }else if(obj.result == '-3'){
							  $('#onlinepattern .pattern-message').html('مدارک یا احراز هویت پنل پیامک شما تایید نشده است');
						  }else if(obj.result == '-4'){
							  $('#onlinepattern .pattern-message').html('نوع درخواست صحیح نمی باشد');
						  }else if(obj.result == '-5'){
							  $('#onlinepattern .pattern-message').html('آی پی سرور سایت شما برای کلید اتصال شما تعریف نشده است');
						  }else{
							  $('#onlinepattern .pattern-message').html('در دریافت اطلاعات پترن خطایی رخ داده است');
						  }
        },
        complete: function(){
            $('#onlinepattern .pattern-message .process-icon-loading').hide();
        },
    });

    return false;
});
});
$('.mydnspanel-smstest').on('click',function(){
$('.send-test-sms-mobile').parent().remove();
var trid = $(this).parents('tr').attr('id');
$(this).after('<div><input class="send-test-sms-mobile" id="'+trid+'_test_mobile" type="text" placeholder="تلفن همراه" /><span class="send-test-sms-btn" id="'+trid+'_sendTestSms">ارسال</span><br><span class="result"></span></div>');
$('#'+trid+'_sendTestSms').on('click',function(){
var phone = $('input#'+trid+'_test_mobile').val();
var body = $('#'+trid).find('textarea').val();
var result = pwoo_sms_mydnspanel_test(phone,body,$(this).parent().find('span.result'));
if(result == 'phonenotfound') {
    $('input#'+trid+'_test_mobile').focus();
    return false;
}

});
return false;
});

}
function pwoo_sms_mydnspanel_test(phone,body,resultbox){
if ( phone === '' ) {
alert('لطفاً یک شماره همراه برای دریافت پیامک تست وارد کنید.');
return 'phonenotfound';
}
var data  = {
action : 'pwoo_sms_mydnspanel_test',
phone : phone,
body : body,
};

$.post( ajaxurl, data, function( resp ) {
console.log(resp);
if ( resp == '1' ) {
      resultbox.html('<span style="color:green">پیامک تست ارسال شد.</span>');
}else{
      resultbox.html('<span style="color:red">پیامک ارسال نشد. تنظیمات درگاه و اعتبار پنل پیامک و متن ارسالی را بررسی کنید.</span>');
}
});
return false;
}
$(document).ready(function(){
activate_pwoosms_mydnspanel_pattern_tools();
});

} )( jQuery );
</script>
<style>
.send-test-sms-mobile {
	padding: 0px 2px !important;
    direction: ltr;
    width: 50% !important;
    border-radius: 0 5px 5px 0 !important;
    margin-top: 5px !important;
	text-align:center !important;
}
.send-test-sms-btn {
background: #1a3b7b;
border-color: #1a3b7b;
color: #fff;
text-decoration: none;
text-shadow: none;
cursor: pointer;
display: inline-block;
font-size: 13px;
line-height: 2.15384615;
min-height: 30px;
margin: 0;
padding: 0 10px;
border-width: 1px;
border-style: solid;
-webkit-appearance: none;
border-radius: 3px;
white-space: nowrap;
box-sizing: border-box;
font-weight: normal;
margin-top: 5px !important;
border-radius: 5px 0 0 5px !important;
}
.mydnspanel-tools a{
cursor: pointer;
}
#TB_ajaxContent{
direction: rtl;
text-align: right!important;
}
#TB_ajaxContent p {
margin: 0;
}
#onlinepattern .pattern-message {
background: #dffde1;
padding: 10px;
border-radius: 5px;
border: 1px solid #bbb;
margin: 10px;
color: #666;
}
.mydnspanel-tools a {
display: block!important;
width: 150px;
text-align: center;
}
</style>
    <?php
}
function mydnspanelsms_getErrors($error)
{
    $errorCodes = [
        "-5" => "ای پی سرور سایت در لیست ای پی های مجاز کلید دسترسی نمی باشد",
		"-4" => "نوع درخواست صحیح نمی باشد",
		"-3" => "مدارک یا احراز هویت حساب تایید نشده است",
		"-2" => "دسترسی وب سرویس غیرفعال است",
		"-1" => "کلید اتصال به وب سرویس صحیح نمی باشد",
		"0" => "درخواست صحیح نمی باشد",
		"1" => "عملیات با موفقیت انجام شد",
		"100" => "متد درخواستی صحیح نمی باشد",
		"103" => "نوع ارسال درخواستی صحیح نیست",
		"104" => "دسترسی ارسال شما به نوع ارسال درخواستی غیرفعال است",
		"105" => "گیرنده / گیرندگان پیام معتبر نمی باشد",
		"106" => "شماره فرستنده پیام معتبر نمی باشد",
		"107" => "متن ارسالی معتبر نمی باشد",
		"108" => "اعتبار ارسال قابل پردازش نمی باشد",
		"109" => "اعتبار کافی نیست",
		"112" => "خطای اپراتور ارسال کننده پیامک",
		"113" => "خطای غیرمنتظره ای در ارسال پیام رخ داده است",
		"114" => "مدارک و یا احراز هویت حساب تایید نشده است",
		"603" => "شماره فرستنده پیام معتبر نمی باشد",
		"604" => "گیرنده / گیرندگان پیام معتبر نمی باشد",
		"605" => "کد متن پیام ارسالی صحیح نمی باشد",
		"606" => "متغییر های متن پیام ارسالی صحیح نمی باشد",
		"607" => "اعتبار ارسال قابل پردازش نمی باشد",
		"608" => "اعتبار کافی نیست",
		"609" => "امکان ارسال گروهی از طریق پترن امکان پذیر نمی باشد",
		"901" => "شناسه پترن صحیح نمی باشد",
		"902" => "پترن در انتظار تایید است",
		"903" => "پترن تایید نشده است",
    ];
    return isset($errorCodes[$error])
        ? $errorCodes[$error]
        : "کد خطا :" . $error;
} ?>
