<?php
// Version: 2.4.1
namespace PW\PWSMS\Gateways;
class MydnsPanelSms implements GatewayInterface
{
    use GatewayTrait;
    public static function id()
    {
        return "mydnspanelsms";
    }
    public static function name()
    {
        return "MYDNSPANEL(افزونه مکمل)";
    }
    public function send()
    {
		$response = false;
		$password = trim($this->password);
		$message = trim($this->message);
		$recipients = $this->mobile;
        $from = trim($this->senderNumber);
		$phoneBookID = trim(PWSMS()->get_option( 'sms_gateway_phoneBook' ));
		$from =$this->senderNumber != "" ? trim($this->senderNumber) : "auto";
		
		if (empty($password)) {
			return '-1';
		}
		if (is_array($recipients)) {
			$to = implode(",", $recipients);
		} else {
			$to = $recipients;
		}
		$massage = strip_tags($message);
		$massage = str_replace(["\\r\\n", "\\n", "\\r"], "\n", $massage);
		$lines = explode("\n", $massage);
		if (isset($lines[0]) && strpos($lines[0], "patternID:") === 0) {
			$lines[0] = str_replace("patternID:", "patterncode:", $lines[0]);
		}
		if (isset($lines[0]) && strpos($lines[0], "patterncode:") === 0) {
			$patterncodeArray = explode(":", $lines[0], 2);
			$patterncode = trim($patterncodeArray[1]);

			$input_data = [];
			foreach (array_slice($lines, 1) as $line) {
				if (trim($line) == "") continue;

				$splited_parm = explode(":", $line, 2);
				if (count($splited_parm) == 2) {
					$key = trim($splited_parm[0]);
					$value = trim($splited_parm[1]);
					$input_data["{" . $key . "}"] = $value;
				}
			}
			$thisTo = explode(",", $to);
			foreach ($thisTo as $toNum) {
				$apiParam = [
					"action" => "sendServices",
					"from" => $from,
					"textCode" => $patterncode,
					"textData" => json_encode($input_data),
					"receivers" => $toNum,
				];
				if ($phoneBookID != "" && $phoneBookID != 0) {
					$apiParam["phoneBook"] = $phoneBookID;
				}
				$result = $this->mydnspanel_sendCUrl($apiParam);
			}
			$response = json_decode($result, true);
			$responseCode = $response["result"];
			$responseSendID = $response["sendID"];
			if ($responseCode == 1) {
				$response = true;
			} else {
				$response = $this->errors_describe($responseCode);
			}
			return $response;
		} else {
			$apiParam = [
				"action" => "send",
				"from" => $from,
				"text" => $massage,
				"receivers" => $to,
			];
			if ($phoneBookID != "" && $phoneBookID != 0) {
				$apiParam["phoneBook"] = $phoneBookID;
			}
			$result = $this->mydnspanel_sendCUrl($apiParam);
			$response = json_decode($result, true);
			$responseCode = $response["result"];
			$responseSendID = $response["sendID"];
			if ($responseCode == 1) {
				$response = true;
			} else {
				$response = $this->errors_describe($responseCode);
			}
			return $response;
		}
    }
	private function mydnspanel_sendCUrl($params = [], $method = "POST")
	{
		$params["xPlugin"] = "persian-woo.2-4";
		$apiHandler = curl_init("mydnspanel.com/webservice/server");
		curl_setopt($apiHandler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($apiHandler, CURLOPT_HTTPHEADER, [
			"Authorization: " . trim($this->password),
		]);
		curl_setopt($apiHandler, CURLOPT_POSTFIELDS, $params);
		curl_setopt($apiHandler, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($apiHandler, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($apiHandler, CURLOPT_TIMEOUT, 30);
		curl_setopt($apiHandler, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($apiHandler, CURLOPT_SSL_VERIFYPEER, 0);
		$response = curl_exec($apiHandler);
		if (curl_errno($apiHandler)) {
			return json_encode([
				"result" => "-1",
				"error" => curl_error($apiHandler),
			]);
		}
		return $response;
	}
    private function errors_describe($error)
    {
        $errorCodes = [
        "-5" => "ای پی سرور سایت در لیست ای پی های مجاز کلید دسترسی نمی باشد",
		"-4" => "نوع درخواست صحیح نمی باشد",
		"-3" => "مدارک یا احراز هویت حساب تایید نشده است",
		"-2" => "دسترسی وب سرویس غیرفعال است",
		"-1" => "کلید اتصال به وب سرویس صحیح نمی باشد",
		"0" => "درخواست صحیح نمی باشد",
		"1" => "عملیات با موفقیت انجام شد",
		"100" => "متد درخواستی صحیح نمی باشد",
		"103" => "نوع ارسال درخواستی صحیح نیست",
		"104" => "دسترسی ارسال شما به نوع ارسال درخواستی غیرفعال است",
		"105" => "گیرنده / گیرندگان پیام معتبر نمی باشد",
		"106" => "شماره فرستنده پیام معتبر نمی باشد",
		"107" => "متن ارسالی معتبر نمی باشد",
		"108" => "اعتبار ارسال قابل پردازش نمی باشد",
		"109" => "اعتبار کافی نیست",
		"112" => "خطای اپراتور ارسال کننده پیامک",
		"113" => "خطای غیرمنتظره ای در ارسال پیام رخ داده است",
		"114" => "مدارک و یا احراز هویت حساب تایید نشده است",
		"603" => "شماره فرستنده پیام معتبر نمی باشد",
		"604" => "گیرنده / گیرندگان پیام معتبر نمی باشد",
		"605" => "کد متن پیام ارسالی صحیح نمی باشد",
		"606" => "متغییر های متن پیام ارسالی صحیح نمی باشد",
		"607" => "اعتبار ارسال قابل پردازش نمی باشد",
		"608" => "اعتبار کافی نیست",
		"609" => "امکان ارسال گروهی از طریق پترن امکان پذیر نمی باشد",
		"901" => "شناسه پترن صحیح نمی باشد",
		"902" => "پترن در انتظار تایید است",
		"903" => "پترن تایید نشده است",
        ];
        return isset($errorCodes[$error])
            ? $errorCodes[$error]
            : "کد خطا :" . $error;
    }
}
