Imports System
Imports System.Web.Services
Imports System.Text
Imports System.IO
Imports System.Runtime.Serialization.Json
Imports System.Collections.Generic

Module Program

    Dim apiKey As String = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
    Dim client As New MyDnsPanelService.WebServiceSoapClient()

    Sub Main()

        ' ==================== send ====================
        SendMessage()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== sendPeer ====================
        SendPeer()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== sendServices ====================
        SendServices()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== reportSend ====================
        ReportSend()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== receivedMessages ====================
        ReceivedMessages()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== newContact ====================
        NewContact()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== credit ====================
        GetCredit()

        Console.WriteLine(New String("-"c, 50))

        ' ==================== status ====================
        GetStatus()

        Console.WriteLine(New String("-"c, 50))

        Console.WriteLine("پایان اجرا - برای خروج Enter بزنید.")
        Console.ReadLine()
    End Sub

    ' ---------------- send ----------------
    Private Sub SendMessage()
        Dim responseJson As String = client.send(apiKey, Nothing, "9850004988", "This is a test message.", "989120000000", Nothing, 1, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("send", response)
    End Sub

    ' ---------------- sendPeer ----------------
    Private Sub SendPeer()
        Dim fromPeer As String = "[ ""9850004988"", ""9850004988"" ]"
        Dim textPeer As String = "[ ""This is a test message."", ""This is a test message 2.""]"
        Dim receiversPeer As String = "[ ""989120000000"", ""989120000001"" ]"

        Dim responseJson As String = client.sendPeer(apiKey, Nothing, fromPeer, textPeer, receiversPeer, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("sendPeer", response)
    End Sub

    ' ---------------- sendServices ----------------
    Private Sub SendServices()
        Dim textData As String = "{""{code}"":" & """1234""}"
        Dim responseJson As String = client.sendServices(apiKey, "auto", 1234, textData, "989120000000", Nothing, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("sendServices", response)
    End Sub

    ' ---------------- reportSend ----------------
    Private Sub ReportSend()
        Dim sendID As Long = 0 ' اینجا ID واقعی ارسال رو قرار بدید
        Dim responseJson As String = client.reportSend(apiKey, sendID)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("reportSend", response)
    End Sub

    ' ---------------- receivedMessages ----------------
    Private Sub ReceivedMessages()
        Dim responseJson As String = client.receivedMessages(apiKey, 10, 0, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("receivedMessages", response)
    End Sub

    ' ---------------- newContact ----------------
    Private Sub NewContact()
        Dim responseJson As String = client.newContact(apiKey, 1, "989120000000", Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("newContact", response)
    End Sub

    ' ---------------- credit ----------------
    Private Sub GetCredit()
        Dim responseJson As String = client.credit(apiKey, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("credit", response)
    End Sub

    ' ---------------- status ----------------
    Private Sub GetStatus()
        Dim responseJson As String = client.status(apiKey, Nothing)
        Dim response = DeserializeJson(responseJson)
        PrintResponse("status", response)
    End Sub

    ' ---------------- JSON Helper ----------------
    Public Function DeserializeJson(json As String) As Dictionary(Of String, Object)
        Try
            Dim ser As New DataContractJsonSerializer(GetType(Dictionary(Of String, Object)))
            Using ms As New MemoryStream(Encoding.UTF8.GetBytes(json))
                Return CType(ser.ReadObject(ms), Dictionary(Of String, Object))
            End Using
        Catch ex As Exception
            Console.WriteLine("JSON Parse Error: " & ex.Message)
            Return New Dictionary(Of String, Object)
        End Try
    End Function

    ' ---------------- Print Helper ----------------
    Private Sub PrintResponse(methodName As String, response As Dictionary(Of String, Object))
        If response.ContainsKey("result") AndAlso response("result").ToString() = "1" Then
            Console.WriteLine(methodName & " request successfully.")
            For Each kvp In response
                Console.WriteLine(kvp.Key & " : " & kvp.Value)
            Next
        Else
            Console.WriteLine(methodName & " request error.")
            If response.ContainsKey("result") Then Console.WriteLine("Error Code: " & response("result"))
            If response.ContainsKey("error") Then Console.WriteLine("Error Msg: " & response("error"))
        End If
    End Sub

End Module