import Foundation
import SOAPEngine64

let apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

// ایجاد SOAPEngine client
let soap = SOAPEngine()
soap.debug = true // برای چاپ درخواست و پاسخ
soap.version = .VERSION_1_1
soap.soapActionNamespaceDefault = "http://service.mydnspanel.com/"

// Helper برای چاپ پاسخ JSON
func printResponse(_ response: Any?) {
    if let dict = response as? [String: Any] {
        if let result = dict["result"] as? Int, result == 1 {
            print("Request successfully.")
            for (k,v) in dict {
                print("\(k): \(v)")
            }
        } else {
            print("Request error.")
            print("Error Code: \(dict["result"] ?? "unknown")")
            print("Error Message: \(dict["error"] ?? "unknown")")
        }
    } else {
        print("Response: \(response ?? "nil")")
    }
    print("-----------------------------")
}

// ==================== send ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "send", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(nil, forKey: "type")
soap.setValue("9850004988", forKey: "from")
soap.setValue("This is a test message.", forKey: "text")
soap.setValue("989120000000", forKey: "receivers")
soap.setValue(nil, forKey: "phoneBook")
soap.setValue(1, forKey: "trySend")
soap.setValue(nil, forKey: "sendTime")

// ==================== sendPeer ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "sendPeer", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(nil, forKey: "type")
soap.setValue("[\"9850004988\",\"9850004988\"]", forKey: "fromPeer")
soap.setValue("[\"This is a test message.\",\"This is a test message 2.\"]", forKey: "textPeer")
soap.setValue("[\"989120000000\",\"989120000001\"]", forKey: "receiversPeer")
soap.setValue(nil, forKey: "sendTime")

// ==================== sendServices ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "sendServices", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue("auto", forKey: "from")
soap.setValue(1234, forKey: "textCode")
soap.setValue("{\"code\":\"1234\"}", forKey: "textData")
soap.setValue("989120000000", forKey: "receivers")
soap.setValue(nil, forKey: "phoneBook")
soap.setValue(nil, forKey: "trySend")

// ==================== reportSend ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "reportSend", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(0, forKey: "sendID")

// ==================== receivedMessages ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "receivedMessages", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(10, forKey: "limit")
soap.setValue(0, forKey: "offset")
soap.setValue(nil, forKey: "status")

// ==================== newContact ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "newContact", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(1, forKey: "phoneId")
soap.setValue("989120000000", forKey: "cNumber")
soap.setValue(nil, forKey: "cFields")

// ==================== credit ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "credit", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(nil, forKey: "param")

// ==================== status ====================
soap.requestURL("https://mydnspanel.com/webservice/server/soap", soapAction: "status", completeWithDictionary: { dict in
    printResponse(dict)
}, failWithError: { error in
    print("Error: \(error.localizedDescription)")
})
soap.setValue(apiKey, forKey: "apiKey")
soap.setValue(nil, forKey: "param")
