from zeep import Client
import json

wsdl = "https://mydnspanel.com/webservice/server/soap?wsdl"
client = Client(wsdl=wsdl)

apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

def print_response(response):
    if response['result'] == 1:
        print("Request successfully.")
        for k, v in response.items():
            print(f"{k}: {v}")
    else:
        print("Request error.")
        print(f"Error Code: {response['result']}")
        print(f"Error Message: {response.get('error', 'unknown')}")
    print("-----------------------------")

# ==================== send ====================
send_response = client.service.send(
    apiKey,
    None,
    '9850004988',
    'This is a test message.',
    '989120000000',
    None,
    1,
    None
)
send_response = json.loads(send_response)
print_response(send_response)

# ==================== sendPeer ====================
from_peer = json.dumps(['9850004988','9850004988'])
text_peer = json.dumps(['This is a test message.','This is a test message 2.'])
receivers_peer = json.dumps(['989120000000','989120000001'])

send_peer_response = client.service.sendPeer(
    apiKey,
    None,
    from_peer,
    text_peer,
    receivers_peer,
    None
)
send_peer_response = json.loads(send_peer_response)

if send_peer_response['result'] == 1:
    print("sendPeer request successfully.")
    for key, info in send_peer_response['sendData'].items():
        print(f"Group Key: {key}")
        print(f"Send ID: {info['sendID']}")
        print(f"Message Text: {info['text']}")
        print(f"Receivers: {', '.join(info['receivers'])}")
        print(f"Amount Charged: {info['amount']}")
        print(f"Remaining Credit: {info['remainingCredit']}")
        print("-----------------------------")
else:
    print_response(send_peer_response)

# ==================== sendServices ====================
text_data = json.dumps({"code":"1234"})
send_services_response = client.service.sendServices(
    apiKey,
    "auto",
    1234,
    text_data,
    '989120000000',
    None,
    None
)
send_services_response = json.loads(send_services_response)
print_response(send_services_response)

# ==================== reportSend ====================
report_response = client.service.reportSend(apiKey, 0)
report_response = json.loads(report_response)
print_response(report_response)

# ==================== receivedMessages ====================
received_response = client.service.receivedMessages(apiKey, 10, 0, None)
received_response = json.loads(received_response)
print_response(received_response)

# ==================== newContact ====================
new_contact_response = client.service.newContact(apiKey, 1, '989120000000', None)
new_contact_response = json.loads(new_contact_response)
print_response(new_contact_response)

# ==================== credit ====================
credit_response = client.service.credit(apiKey, None)
credit_response = json.loads(credit_response)
print_response(credit_response)

# ==================== status ====================
status_response = client.service.status(apiKey, None)
status_response = json.loads(status_response)
print_response(status_response)