<?php
$wsdl = "https://mydnspanel.com/webservice/server/soap?wsdl";
$options = [
    'cache_wsdl' => WSDL_CACHE_NONE,
    'trace'      => 1,
    'exceptions' => 1
];
$client = new SoapClient($wsdl, $options);
$apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";



// ==================== send ====================
$type = null;
$from = '9850004988';
$text = 'This is a test message.';
$receivers = '989120000000';
$phoneBook = null;
$trySend = 1;
$sendTime = null;

$sendResponse = $client->send($apiKey, $type, $from, $text, $receivers, $phoneBook, $trySend, $sendTime);
$response = json_decode($sendResponse,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "send ID : ".$response["sendID"].".<br>";
	echo "credit : ".$response["credit"].".<br>";
	echo "remaining Credit : ".$response["remainingCredit"];
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}

echo '<hr>';

// ==================== send Peer ====================
$type = null;
$fromPeer = json_encode(array(
0 => '9850004988',
1 => '9850004988',
));
$textPeer = json_encode(array(
0 => 'This is a test message.',
1 => 'This is a test message 2.',
));
$receiversPeer = json_encode(array(
0 => '989120000000',
1 => '989120000001',
));
$sendTime = null;

$sendPeerResponse = $client->sendPeer($apiKey, $type, $fromPeer, $textPeer, $receiversPeer, $sendTime);
$response = json_decode($sendPeerResponse,true);
if($response["result"]==1){
	echo "request successfully.<br>---------------------------<br>";
	$sendData = $response["sendData"];
	foreach ($sendData as $key => $info) {
		echo "Group Key: $key<br>";
		echo "Send ID: " . $info["sendID"] . "<br>";
		echo "Message Text:<br>" . $info["text"] . "<br>";
		echo "Receivers: " . implode(", ", $info["receivers"]) . "<br>";
		echo "Amount Charged: " . $info["amount"] . "<br>";
		echo "Remaining Credit: " . $info["remainingCredit"] . "<br>";
		echo "---------------------------<br>";
	}
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}
	
echo '<hr>';
// ==================== sendServices ====================
$from = "auto";
$textCode = 1234;
$textData = json_encode(["{code}"=>"1234"]);
$receivers = '989120000000';
$phoneBook = null;
$trySend = null;

$sendServicesResponse = $client->sendServices($apiKey, $from, $textCode, $textData, $receivers, $phoneBook, $trySend);
$response = json_decode($sendServicesResponse,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "send ID : ".$response["sendID"].".<br>";
	echo "credit : ".$response["credit"].".<br>";
	echo "remaining Credit : ".$response["remainingCredit"];
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}
	
echo '<hr>';
// ==================== reportSend ====================
$sendID = 0000000000000000;

$reportResponse = $client->reportSend($apiKey, $sendID);
$response = json_decode($reportResponse,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "report Array : ";
	print_r($response["receivers"]);
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}

echo '<hr>';
// ==================== receivedMessages ====================
$limit = 10;
$offset = 0;
$status = null;

$received = $client->receivedMessages($apiKey, $limit, $offset, $status);
$response = json_decode($received,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "received Array : <br>".print_r($response["messages"]);
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}
	
echo '<hr>';
// ==================== newContact ====================
$phoneId = 1;
$cNumber = '989120000000';
$cFields = null;

$newContact = $client->newContact($apiKey, $phoneId, $cNumber, $cFields);
$response = json_decode($newContact,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	if(count($response["fields"]["result"])>0){
		echo "The state of recording the values of the dedicated fields :<br>";
		print_r($response["fields"]["result"]);
	}
} else {
	echo "request error.<br>";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}

echo '<hr>';
// ==================== credit ====================
$credit = $client->credit($apiKey,null);
$response = json_decode($credit,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "credit : ".$response["credit"]."<br>";
} else {
	echo "request error.<br />";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}
	
echo '<hr>';
// ==================== status ====================
$statusResponse = $client->status($apiKey,null);
$response = json_decode($statusResponse,true);
if($response["result"]==1){
	echo "request successfully.<br>";
	echo "status : ".$response["status"]."<br>";
} else {
	echo "request error.<br />";
	echo "error Code : ".$response["result"]."<br>";
	echo "error Message : ".($response["error"]!=null?$response["error"]:"unknown");
}