package com.mydnspanel;

import javax.xml.ws.BindingProvider;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        String apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

        // ایجاد service و port از کلاس‌های تولید شده توسط wsimport
        MyServiceService service = new MyServiceService();
        MyService port = service.getMyServicePort();

        // اضافه کردن header یا تنظیمات در صورت نیاز
        BindingProvider bp = (BindingProvider) port;
        bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, "https://mydnspanel.com/webservice/server/soap");

        try {
            // ==================== send ====================
            String type = null;
            String from = "9850004988";
            String text = "This is a test message.";
            String receivers = "989120000000";
            String phoneBook = null;
            Integer trySend = 1;
            String sendTime = null;

            String sendResponse = port.send(apiKey, type, from, text, receivers, phoneBook, trySend, sendTime);
            System.out.println("sendResponse: " + sendResponse);

            // ==================== sendPeer ====================
            String fromPeer = "[\"9850004988\",\"9850004988\"]";
            String textPeer = "[\"This is a test message.\",\"This is a test message 2.\"]";
            String receiversPeer = "[\"989120000000\",\"989120000001\"]";

            String sendPeerResponse = port.sendPeer(apiKey, type, fromPeer, textPeer, receiversPeer, sendTime);
            System.out.println("sendPeerResponse: " + sendPeerResponse);

            // ==================== sendServices ====================
            String textData = "{\"code\":\"1234\"}";
            String sendServicesResponse = port.sendServices(apiKey, "auto", 1234, textData, "989120000000", null, null);
            System.out.println("sendServicesResponse: " + sendServicesResponse);

            // ==================== reportSend ====================
            String reportResponse = port.reportSend(apiKey, 0L);
            System.out.println("reportResponse: " + reportResponse);

            // ==================== receivedMessages ====================
            String receivedResponse = port.receivedMessages(apiKey, 10, 0, null);
            System.out.println("receivedResponse: " + receivedResponse);

            // ==================== newContact ====================
            String newContactResponse = port.newContact(apiKey, 1, "989120000000", null);
            System.out.println("newContactResponse: " + newContactResponse);

            // ==================== credit ====================
            String creditResponse = port.credit(apiKey, null);
            System.out.println("creditResponse: " + creditResponse);

            // ==================== status ====================
            String statusResponse = port.status(apiKey, null);
            System.out.println("statusResponse: " + statusResponse);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}