package main

import (
	"encoding/json"
	"fmt"
	"log"

	"github.com/hooklift/gowsdl/soap"
)

func main() {
	wsdl := "https://mydnspanel.com/webservice/server/soap?wsdl"
	apiKey := "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

	client, err := soap.NewClient(wsdl)
	if err != nil {
		log.Fatal(err)
	}

	// ==================== send ====================
	sendReq := map[string]interface{}{
		"apiKey":       apiKey,
		"type":         nil,
		"from":         "9850004988",
		"text":         "This is a test message.",
		"receivers":    "989120000000",
		"phoneBook":    nil,
		"trySend":      1,
		"sendTime":     nil,
	}

	var sendResp string
	err = client.Call("send", sendReq, &sendResp)
	if err != nil {
		log.Fatal(err)
	}

	var sendResult map[string]interface{}
	json.Unmarshal([]byte(sendResp), &sendResult)
	printResult(sendResult)

	// ==================== sendPeer ====================
	sendPeerReq := map[string]interface{}{
		"apiKey":        apiKey,
		"type":          nil,
		"fromPeer":      `["9850004988","9850004988"]`,
		"textPeer":      `["This is a test message.","This is a test message 2."]`,
		"receiversPeer": `["989120000000","989120000001"]`,
		"sendTime":      nil,
	}

	var sendPeerResp string
	err = client.Call("sendPeer", sendPeerReq, &sendPeerResp)
	if err != nil {
		log.Fatal(err)
	}
	var peerResult map[string]interface{}
	json.Unmarshal([]byte(sendPeerResp), &peerResult)

	if peerResult["result"].(float64) == 1 {
		fmt.Println("sendPeer request successfully.")
		sendData := peerResult["sendData"].(map[string]interface{})
		for key, info := range sendData {
			infoMap := info.(map[string]interface{})
			fmt.Printf("Group Key: %s\n", key)
			fmt.Printf("Send ID: %s\n", infoMap["sendID"])
			fmt.Printf("Message Text: %s\n", infoMap["text"])
			fmt.Printf("Receivers: %v\n", infoMap["receivers"])
			fmt.Printf("Amount Charged: %v\n", infoMap["amount"])
			fmt.Printf("Remaining Credit: %v\n", infoMap["remainingCredit"])
			fmt.Println("-----------------------------")
		}
	} else {
		printResult(peerResult)
	}

	// ==================== sendServices ====================
	textData := `{"code":"1234"}`
	sendServicesReq := map[string]interface{}{
		"apiKey":   apiKey,
		"from":     "auto",
		"textCode": 1234,
		"textData": textData,
		"receivers":"989120000000",
		"phoneBook": nil,
		"trySend": 0,
	}
	var sendServicesResp string
	err = client.Call("sendServices", sendServicesReq, &sendServicesResp)
	if err != nil {
		log.Fatal(err)
	}
	var sendServicesResult map[string]interface{}
	json.Unmarshal([]byte(sendServicesResp), &sendServicesResult)
	printResult(sendServicesResult)
}

func printResult(result map[string]interface{}) {
	if result["result"].(float64) == 1 {
		fmt.Println("Request successfully.")
		for k, v := range result {
			fmt.Printf("%s: %v\n", k, v)
		}
	} else {
		fmt.Println("Request error.")
		fmt.Printf("Error Code: %v\n", result["result"])
		fmt.Printf("Error Message: %v\n", result["error"])
	}
	fmt.Println("-----------------------------")
}
