using System;
using System.Linq;
using System.Text.Json;
using DNSSoapService; // نام namespace Service Reference شما

class Program
{
    static void Main()
    {
        string apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

        var client = new SoapClient(); // SoapClient از Service Reference ایجاد می شود

        try
        {
            // ==================== send ====================
            var sendResponse = client.send(apiKey, null, "9850004988", "This is a test message.", "989120000000", null, 1, null);
            var sendResult = JsonSerializer.Deserialize<JsonElement>(sendResponse);

            PrintResult(sendResult);

            // ==================== sendPeer ====================
            var fromPeer = JsonSerializer.Serialize(new string[] { "9850004988", "9850004988" });
            var textPeer = JsonSerializer.Serialize(new string[] { "This is a test message.", "This is a test message 2." });
            var receiversPeer = JsonSerializer.Serialize(new string[] { "989120000000", "989120000001" });

            var sendPeerResponse = client.sendPeer(apiKey, null, fromPeer, textPeer, receiversPeer, null);
            var peerResult = JsonSerializer.Deserialize<JsonElement>(sendPeerResponse);

            if (peerResult.GetProperty("result").GetInt32() == 1)
            {
                Console.WriteLine("sendPeer request successfully.");
                foreach (var group in peerResult.GetProperty("sendData").EnumerateObject())
                {
                    var info = group.Value;
                    Console.WriteLine($"Group Key: {group.Name}");
                    Console.WriteLine($"Send ID: {info.GetProperty("sendID").GetString()}");
                    Console.WriteLine($"Text: {info.GetProperty("text").GetString()}");
                    Console.WriteLine($"Receivers: {string.Join(", ", info.GetProperty("receivers").EnumerateArray().Select(x => x.GetString()))}");
                    Console.WriteLine($"Amount Charged: {info.GetProperty("amount").GetString()}");
                    Console.WriteLine($"Remaining Credit: {info.GetProperty("remainingCredit").GetString()}");
                    Console.WriteLine("----------------------------");
                }
            }
            else
            {
                PrintResult(peerResult);
            }

            // ==================== sendServices ====================
            var textData = JsonSerializer.Serialize(new { code = "1234" });
            var sendServicesResponse = client.sendServices(apiKey, "auto", 1234, textData, "989120000000", null, null);
            var sendServicesResult = JsonSerializer.Deserialize<JsonElement>(sendServicesResponse);
            PrintResult(sendServicesResult);

            // ==================== reportSend ====================
            var reportResponse = client.reportSend(apiKey, 0000000000000000);
            var reportResult = JsonSerializer.Deserialize<JsonElement>(reportResponse);
            PrintResult(reportResult);

            // ==================== receivedMessages ====================
            var receivedResponse = client.receivedMessages(apiKey, 10, 0, null);
            var receivedResult = JsonSerializer.Deserialize<JsonElement>(receivedResponse);
            PrintResult(receivedResult);

            // ==================== newContact ====================
            var newContactResponse = client.newContact(apiKey, 1, "989120000000", null);
            var newContactResult = JsonSerializer.Deserialize<JsonElement>(newContactResponse);
            PrintResult(newContactResult);

            // ==================== credit ====================
            var creditResponse = client.credit(apiKey, null);
            var creditResult = JsonSerializer.Deserialize<JsonElement>(creditResponse);
            PrintResult(creditResult);

            // ==================== status ====================
            var statusResponse = client.status(apiKey, null);
            var statusResult = JsonSerializer.Deserialize<JsonElement>(statusResponse);
            PrintResult(statusResult);

        }
        catch (Exception ex)
        {
            Console.WriteLine("Error: " + ex.Message);
        }
    }

    static void PrintResult(JsonElement result)
    {
        if (result.GetProperty("result").GetInt32() == 1)
        {
            Console.WriteLine("Request successfully.");
            foreach (var prop in result.EnumerateObject())
            {
                Console.WriteLine($"{prop.Name}: {prop.Value}");
            }
        }
        else
        {
            Console.WriteLine("Request error.");
            Console.WriteLine("Error Code: " + result.GetProperty("result").GetInt32());
            Console.WriteLine("Error Message: " + (result.TryGetProperty("error", out var err) ? err.GetString() : "unknown"));
        }
        Console.WriteLine("-----------------------------");
    }
}