#include "soapH.h"
#include "myserviceSoap.nsmap"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main() {
    struct soap soap;
    soap_init(&soap);

    const char *apiKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

    // ==================== send ====================
    _ns1__send reqSend;
    _ns1__sendResponse respSend;

    reqSend.apiKey = (char*)apiKey;
    reqSend.type = NULL;
    reqSend.from = "9850004988";
    reqSend.text = "This is a test message.";
    reqSend.receivers = "989120000000";
    reqSend.phoneBook = NULL;
    reqSend.trySend = 1;
    reqSend.sendTime = NULL;

    if(soap_call___ns1__send(&soap, NULL, NULL, &reqSend, &respSend) == SOAP_OK) {
        printf("send result: %d\n", respSend.result);
        if(respSend.result == 1) {
            printf("Send ID: %s\n", respSend.sendID);
            printf("Credit: %s\n", respSend.credit);
            printf("Remaining Credit: %s\n", respSend.remainingCredit);
        } else {
            printf("Error: %s\n", respSend.error ? respSend.error : "unknown");
        }
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== sendPeer ====================
    _ns1__sendPeer reqPeer;
    _ns1__sendPeerResponse respPeer;

    // نمونه آرایه json برای sendPeer
    reqPeer.apiKey = (char*)apiKey;
    reqPeer.type = NULL;
    reqPeer.fromPeer = "[\"9850004988\",\"9850004988\"]";
    reqPeer.textPeer = "[\"This is a test message.\",\"This is a test message 2.\"]";
    reqPeer.receiversPeer = "[\"989120000000\",\"989120000001\"]";
    reqPeer.sendTime = NULL;

    if(soap_call___ns1__sendPeer(&soap, NULL, NULL, &reqPeer, &respPeer) == SOAP_OK) {
        printf("sendPeer result: %d\n", respPeer.result);
        if(respPeer.result == 1) {
            printf("sendData: %s\n", respPeer.sendData);
        } else {
            printf("Error: %s\n", respPeer.error ? respPeer.error : "unknown");
        }
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== sendServices ====================
    _ns1__sendServices reqServ;
    _ns1__sendServicesResponse respServ;

    reqServ.apiKey = (char*)apiKey;
    reqServ.from = "auto";
    reqServ.textCode = 1234;
    reqServ.textData = "{\"code\":\"1234\"}";
    reqServ.receivers = "989120000000";
    reqServ.phoneBook = NULL;
    reqServ.trySend = 0;

    if(soap_call___ns1__sendServices(&soap, NULL, NULL, &reqServ, &respServ) == SOAP_OK) {
        printf("sendServices result: %d\n", respServ.result);
        if(respServ.result == 1) {
            printf("Send ID: %s\n", respServ.sendID);
            printf("Credit: %s\n", respServ.credit);
            printf("Remaining Credit: %s\n", respServ.remainingCredit);
        } else {
            printf("Error: %s\n", respServ.error ? respServ.error : "unknown");
        }
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== reportSend ====================
    _ns1__reportSend reqReport;
    _ns1__reportSendResponse respReport;

    reqReport.apiKey = (char*)apiKey;
    reqReport.sendID = 0;

    if(soap_call___ns1__reportSend(&soap, NULL, NULL, &reqReport, &respReport) == SOAP_OK) {
        printf("reportSend result: %d\n", respReport.result);
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== receivedMessages ====================
    _ns1__receivedMessages reqRecv;
    _ns1__receivedMessagesResponse respRecv;

    reqRecv.apiKey = (char*)apiKey;
    reqRecv.limit = 10;
    reqRecv.offset = 0;
    reqRecv.status = NULL;

    if(soap_call___ns1__receivedMessages(&soap, NULL, NULL, &reqRecv, &respRecv) == SOAP_OK) {
        printf("receivedMessages result: %d\n", respRecv.result);
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== newContact ====================
    _ns1__newContact reqContact;
    _ns1__newContactResponse respContact;

    reqContact.apiKey = (char*)apiKey;
    reqContact.phoneId = 1;
    reqContact.cNumber = "989120000000";
    reqContact.cFields = NULL;

    if(soap_call___ns1__newContact(&soap, NULL, NULL, &reqContact, &respContact) == SOAP_OK) {
        printf("newContact result: %d\n", respContact.result);
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== credit ====================
    _ns1__credit reqCredit;
    _ns1__creditResponse respCredit;

    reqCredit.apiKey = (char*)apiKey;
    reqCredit.param = NULL;

    if(soap_call___ns1__credit(&soap, NULL, NULL, &reqCredit, &respCredit) == SOAP_OK) {
        printf("credit result: %d\n", respCredit.result);
    } else {
        soap_print_fault(&soap, stderr);
    }

    printf("----------------------------\n");

    // ==================== status ====================
    _ns1__status reqStatus;
    _ns1__statusResponse respStatus;

    reqStatus.apiKey = (char*)apiKey;
    reqStatus.param = NULL;

    if(soap_call___ns1__status(&soap, NULL, NULL, &reqStatus, &respStatus) == SOAP_OK) {
        printf("status result: %d\n", respStatus.result);
    } else {
        soap_print_fault(&soap, stderr);
    }

    soap_end(&soap);
    soap_done(&soap);

    return 0;
}